/*
 Wireless Grapher version 0.6
 Copyright 2005-2009 Jeffrey Nelson (nelsonjm@macpod.net). All rights reserved.
 */


// === Dirty global variables ===

// Button color values
const buttonGrey = 0;
const buttonGreen = 1;
const buttonYellow = 10;
const buttonRed = 15;

// Timer stuff
const timerIntervalMax = 10;
const timerIntervalMin = 1;
const timerIntervalDefault = 1;
var timerInterval = timerIntervalDefault;
var timer = null;
var updateWhileHidden = false;

// Graph drawing stuff
const blocksize = 4.7; // Size of bar is set to a wierd value in order to overlap samples.
const graphAdjust = 4.3; // used for adjusting where bar on left side is on canvas
const bufferSamples = 1; // used to make sure the graph is filled up.
var RSSIData;
var noiseData;


// Called by HTML body element's onload event when the widget is ready to start
function load()
{
    dashcode.setupParts();
	
	if (window.widget)
	{
		// We know we are running in Dashboard now

		// Check to see if a timer interval was set, otherwise set the default to 1.
		timerInterval = widget.preferenceForKey("timerInterval");
		if (isNaN(timerInterval) || timerInterval > timerIntervalMax || timerInterval < timerIntervalMin) {
			document.getElementById("timerPopup").selectedIndex = timerIntervalDefault - 1;
			timerInterval = timerIntervalDefault;
		} else {
			document.getElementById("timerPopup").selectedIndex = timerInterval;
			timerInterval += 1;
		}
		
		// Identify if we should update when the widget is hidden.
		updateWhileHidden = widget.preferenceForKey("updateWhileHidden");
		document.getElementById("updateWhileHiddenCheckbox").checked = updateWhileHidden;
		
		// Find status button (an apple indicator widget) and set it to grey
		document.getElementById("button").object.setValue(buttonGrey); // grey
		
		// Find the status text and set it to the default value
		statusText = document.getElementById("statusText");
		document.getElementById("statusText").innerHTML = getLocalizedString('Information Unavaliable');
		
		// Set other text elements to show localized strings if available.
		document.getElementById("updateTimerText").innerHTML = getLocalizedString('Update every:');
		document.getElementById("updateWhileHiddenText").innerHTML = getLocalizedString('Update While Hidden');
		
		// Find the canvas so we can get it's width and height.
		var canvas = document.getElementById("canvas");
		var width = canvas.width;
		var height = canvas.height;
		
		// create the graph data arrays and set all elements to zero.
		RSSIData = new Array(Math.round(width/blocksize) + bufferSamples);
		noiseData = new Array(Math.round(width/blocksize) + bufferSamples);
		for (var x=0; x < RSSIData.length; x++)
		{
			RSSIData[x] = 0;
			noiseData[x] = 0;
		}
	}
}


// Called when the widget has been removed from the Dashboard
function remove()
{
    stopTimer();
    // widget.setPreferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
}


// Called when the widget has been hidden
function hide()
{
	// Stop the update timer if the user does not want to update while the widget is hidden.
	if (!updateWhileHidden)
	{
		stopTimer();
	}
}


// Called when the widget has been shown
function show()
{
	// Start the update timer.
	startTimer();
}


// Called when the widget has been synchronized with .Mac
function sync()
{
    // Retrieve any preference values that you need to be synchronized here
    // Use this for an instance key's value:
    // instancePreferenceValue = widget.preferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
    //
    // Or this for global key's value:
    // globalPreferenceValue = widget.preferenceForKey(null, "your-key");
}


// Called when the info button is clicked to show the back of the widget
function showBack(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToBack");
    }

    front.style.display = "none";
    back.style.display = "block";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}


// Called when the done button is clicked from the back of the widget
function showFront(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToFront");
    }

    front.style.display="block";
    back.style.display="none";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}


if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
    widget.onsync = sync;
}

// Called when the update while hidden checkbox is clicked.
function toggleUpdateWhileHidden(event)
{
	if (window.widget) {
	    // We know we are running in Dashboard now
		updateWhileHidden = document.getElementById("updateWhileHiddenCheckbox").checked;
		widget.setPreferenceForKey(updateWhileHidden, "updateWhileHidden");
	}
}


// Called when a timer pulldown menu item is choosen
function changeTimer(event)
{
	if (window.widget) {
		// We know we are running in Dashboard now
		stopTimer();
		var timerPopup = document.getElementById("timerPopup");
		
		if (timerPopup.selectedIndex > timerIntervalMax || timerPopup.selectedIndex < timerIntervalMin) {
			timerInterval = timerIntervalDefault;
			widget.setPreferenceForKey(timerInterval, "timerInterval");
		} else {
			timerInterval = timerPopup.selectedIndex + 1;
			widget.setPreferenceForKey(timerPopup.selectedIndex, "timerInterval");
		}
		startTimer();
	}
}


// Send them to the website!
function logoClick(event)
{
	if (window.widget)
	{
		// We know we are running in Dashboard now
		widget.openURL('http://macpod.net');
	}
}


// Call the airport command so we can grab it's output. 
function updateSample()
{    
	if (window.widget)
	{
		// We know we are running in Dashboard now
		
		try {
			widget.system("/System/Library/PrivateFrameworks/Apple80211.framework/Resources/airport -I", processSample);
		} catch (err) {
			document.getElementById("button").object.setValue(buttonRed); // red
			statusText.innerHTML = getLocalizedString('Error running airport tool.');
		}
	}
}


// Process the airport command's output so we can update the interface.
function processSample(command)
{
	var readSampleData = false;
    var airportOn = true;
	var ssid = '';
	var channel = '';
	var agrCtlRSSI = -100;
	var agrCtlNoise = -100;


	if (command.status == 0) {
		// Parse the output of the command for data.
		var arguments = command.outputString.split('\n');
	
		for(var i=0; i<arguments.length; i++) {
			if (arguments[i].search("AirPort: Off") != -1) {
				// Airport is turned off.
				airportOn = false;
				readSampleData = true;
				break;	
			} else if (arguments[i].search("[^B]SSID:") != -1) {
				// Read the SSID we are connected to.
				ssid = arguments[i].slice(arguments[i].indexOf(':') + 1).trim();
				readSampleData = true;
			} else if (arguments[i].search("agrCtlRSSI:") != -1) {
				// Read the RSSI level
				agrCtlRSSI = arguments[i].slice(arguments[i].indexOf(':') + 1).trim();
				agrCtlRSSI = parseInt(agrCtlRSSI);
				readSampleData = true;
			} else if (arguments[i].search("agrCtlNoise:") != -1) {
				// Read in Noise level
				agrCtlNoise = arguments[i].slice(arguments[i].indexOf(':') + 1).trim();
				agrCtlNoise = parseInt(agrCtlNoise);
				readSampleData = true;
			} else if (arguments[i].search("channel:") != -1) {
				channel = arguments[i].slice(arguments[i].indexOf(':') + 1).trim();
				readSampleData = true;
			}
		}
	}

	if (command.status != 0 || !readSampleData) {
		// Error
		document.getElementById("button").object.setValue(buttonRed); // red
		statusText.innerHTML = getLocalizedString('Error reading wireless data.');
	} else {
		if (airportOn && ssid == '') {
			// Airport is on, but we are not connected to a network
			document.getElementById("button").object.setValue(buttonYellow); // Yellow
			statusText.innerHTML = getLocalizedString('Not connected.');
		} else if (airportOn) { 
			// Airport is on, and we are connected to a network
			document.getElementById("button").object.setValue(buttonGreen); // Green
			statusText.innerHTML = getLocalizedString('Network: ') + ssid;
			if (channel != -1) {
				// State the channel if we know it.
				statusText.innerHTML += ' Channel(s): ' + channel;
			}
		} else {
			// Airport must be off
			document.getElementById("button").object.setValue(buttonGrey); // grey
			statusText.innerHTML = getLocalizedString('Wireless power not on.');
		}
	}
	
	// Move the oldest sample out.
	RSSIData.shift();
	noiseData.shift();
		
	// Insert the new samples after verifying they are within range.
	RSSIData.push(100 + agrCtlRSSI);
	noiseData.push(100 + agrCtlNoise);	
	
	drawGraph();

}


function drawGraph()
{
	// Find the canvas so we can get it's width and height.
	var canvas = document.getElementById("canvas");
	var width = canvas.width;
	var height = canvas.height;
	// Find canvas and get it's context for drawing.
	context = canvas.getContext("2d");
	
	// Clear graph and redraw the data.
	context.clearRect(0,0,width,height);
	var x;
	for (x=0; x < RSSIData.length; x++) // Draw the bars
	{
		var linkBarHeight = (height/ 100) * RSSIData[x];
		if (linkBarHeight > height)
			linkBarHeight = height;
		var linkBarOffset = height - linkBarHeight; 
		context.fillStyle = 'rgba(64, 64, 255, .5)'; // RSSI bar 
		context.fillRect(x * blocksize - graphAdjust, linkBarOffset, width/50, linkBarHeight);
		var commsBarHeight = (height/ 100) * noiseData[x];
		if (commsBarHeight > height)
			commsBarHeight = height;
		var commsBarOffset = height - commsBarHeight;
		
		context.fillStyle = 'rgba(64, 255, 64, .5)'; // Noise bar
		context.fillRect(x * blocksize - graphAdjust, commsBarOffset, width/50, commsBarHeight);
		context.fillStyle = 'rgba(32, 32, 255, 1)'; // RSSI bar cap
		context.fillRect(x * blocksize - graphAdjust, linkBarOffset, width/50, 2);
		context.fillStyle = 'rgba(32, 255, 32, 1)'; // Noise bar cap
		context.fillRect(x * blocksize - graphAdjust, commsBarOffset, width/50, 2);
	}
}


// Stops timer so interface is not updated.
function stopTimer()
{
	if ( timer != null )
	{
		clearInterval(timer);
		timer = null;
	}
}


// Starts timer so interface is updated.
function startTimer()
{
	if ( timer != null )
	{
		// Wipe the timer if it was already present.
		clearInterval(timer);
		timer = null;
	}
	if (isNaN(timerInterval) || timerInterval > timerIntervalMax || timerInterval < timerIntervalMin) {
		
		timerInterval = timerIntervalDefault;
	}
	timer = setInterval("updateSample();", 1000 * timerInterval);
}


// Trims white space from the front and tail of a string.
String.prototype.trim=function(){
	return this.replace(/^\s*|\s*$/g,'');
}
